<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/restaurants';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }

    // protected function attemptLogin(Request $request)
    // {
    //     // sirf admin panel ke liye login allow
    //     return Auth::attempt(
    //         [
    //             'email' => $request->email,
    //             'password' => $request->password,
    //             'role' => 'admin' // sirf admin login ho
    //         ],
    //         $request->filled('remember')
    //     );
    // }


    protected function attemptLogin(Request $request)
    {
        // admin ya static dono allow
        $user = \App\Models\User::where('email', $request->email)->first();

        if ($user && in_array($user->role, ['admin', 'static'])) {
            return Auth::attempt(
                [
                    'email' => $request->email,
                    'password' => $request->password,
                ],
                $request->filled('remember')
            );
        }

        return false; // agar role match nahi karta
    }

    protected function sendFailedLoginResponse(Request $request)
    {
        return redirect()->back()
            ->withErrors(['email' => 'You doesnt have acces to this portal!']);
    }

}
